<?php

declare(strict_types=1);

namespace WOWGmbH\Wownaechtebuch\Domain\Repository;


/**
 * This file is part of the "WOW Naechtebuch" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * (c) 2024 WOW-GmbH <technik@wow.gmbh>, WOW-GmbH
 */
use TYPO3\CMS\Extbase\Persistence\QueryInterface;
use TYPO3\CMS\Extbase\Persistence\QueryResultInterface;

/**
 * The repository for Surveys
 */
class SurveyRepository extends \TYPO3\CMS\Extbase\Persistence\Repository
{
    public function findByUids(array $uids): QueryResultInterface
    {
      $query = $this->createQuery();
      return $query
          ->matching($query->in('uid', $uids))
          ->execute();
    }
}
