<?php

declare(strict_types=1);

namespace WOWGmbH\Wownaechtebuch\Event;
use \WOWGmbH\Wownaechtebuch\Domain\Model\ParentUser;

final class NewParentUserEvent
{
    public function __construct(
        private ParentUser $parentUser,
    ) {}

    public function getParentUser(): ParentUser
    {
        return $this->parentUser;
    }

    public function setParentUser(ParentUser $parentUser): void
    {
        $this->parentUser = $parentUser;
    }
}