<?php

declare(strict_types=1);

namespace WOWGmbH\Wownaechtebuch\EventListener;

use TYPO3\CMS\Core\Attribute\AsEventListener;
use In2code\Femanager\Event\BeforeUserConfirmEvent ;
use \WOWGmbH\Wownaechtebuch\Domain\Repository\ParentUserRepository;
use \WOWGmbH\Wownaechtebuch\Domain\Model\ParentUser;
use \TYPO3\CMS\Core\Utility\DebugUtility;
use \TYPO3\CMS\Core\Utility\GeneralUtility;

final readonly class CreateParentUserAfterUserConfirmed
{
      /**
     * parentUserRepository
     *
     * @var \WOWGmbH\Wownaechtebuch\Domain\Repository\ParentUserRepository
     */
    protected ?ParentUserRepository $parentUserRepository;

    /**
     * @param \WOWGmbH\Wownaechtebuch\Domain\Repository\ParentUserRepository $parentUserRepository
     */
    public function injectParentUserRepository(\WOWGmbH\Wownaechtebuch\Domain\Repository\ParentUserRepository $parentUserRepository)
    {
        $this->parentUserRepository = $parentUserRepository;
    }
    
    public function __invoke(BeforeUserConfirmEvent  $event): void
    {
      $user = $event->getUser();
      
      if ($this->parentUserRepository->count(['user' => $user->getUid()]) == 0) {
        $parentUser = GeneralUtility::makeInstance(ParentUser::class);
        
        $parentUser->setFirstName($user->getFirstName());
        $parentUser->setLastName($user->getLastName());
        $parentUser->setEmail($user->getEmail());
        $parentUser->setCity($user->getCity());
        $parentUser->setZip($user->getZip());
        $parentUser->setRegion("");
        $parentUser->setCountry($user->getCountry());
        $parentUser->setState(0);
        $parentUser->setUser($user);
        $parentUser->setGender($user->getGender());

        $this->parentUserRepository->add($parentUser);
      }

    }
}
