<?php

declare(strict_types=1);

namespace WOWGmbH\Wownaechtebuch\EventListener;

use \WOWGmbH\Wownaechtebuch\Domain\Repository\LetterRecordRepository;
use \setasign\Fpdi\Fpdi;
use \WOWGmbH\Wownaechtebuch\Event\NewLetterRecordEvent;
use TYPO3\CMS\Core\Resource\ResourceFactory;
use TYPO3\CMS\Core\Resource\StorageRepository;
use TYPO3\CMS\Core\DataHandling\DataHandler;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Utility\StringUtility;
use \TYPO3\CMS\Extbase\Persistence\Generic\PersistenceManager;
use Symfony\Component\Mime\Address;
use TYPO3\CMS\Core\Database\Connection;
use TYPO3\CMS\Core\Mail\FluidEmail;
use TYPO3\CMS\Core\Mail\MailerInterface;
use WOWGmbH\Wownaechtebuch\Domain\Model\Letter;
use TYPO3\CMS\Core\Database\ConnectionPool;

use \TYPO3\CMS\Core\Resource\FileInterface;

final readonly class CreatePdfAfterNewLetterRecord
{
    public function __construct(
        private readonly StorageRepository $storageRepository,
        private readonly ResourceFactory $resourceFactory,
        private readonly LetterRecordRepository $letterRecordRepository,
        private readonly PersistenceManager $persistenceManager,
        private readonly ConnectionPool $connectionPool,
    ) {}

    public function __invoke(NewLetterRecordEvent  $event): void
    {
        $letterRecord = $event->getLetterRecord();
        $this->createPdf($letterRecord);
        $this->letterRecordRepository->update($letterRecord);
        $this->persistenceManager->persistAll();
    }

    function createPdf(\WOWGmbH\Wownaechtebuch\Domain\Model\LetterRecord &$letterRecord)
    {
        // Check Action
        // $status = $letterRecord->getState();
        // $sent = $letterRecord->getSent();
        $uid = $letterRecord->getUid();
        $LetterUid = $letterRecord->getLetter()->getUid();
        $number = $letterRecord->getNumber();
        $date = date("Y-m-d");
        $user = $letterRecord->getLetter()->getTreatmentRun()->getChild()->getParentUser();
        $decodedText = iconv('UTF-8', 'windows-1252', html_entity_decode(strip_tags($letterRecord->getText())));

        // Create PDF
        $pdf = new class extends FPDI {
            protected $_tplIdx;
            protected $_otherPageTplIdx;

            public function Header()
            {
                if ($this->PageNo() === 1) {
                    if (null === $this->_tplIdx) {
                        $this->setSourceFile('/html/typo3-composer/packages/wownaechtebuch/Resources/Public/Pdf/STE_Briefboegen_20211103.pdf');
                        $this->_tplIdx = $this->importPage(1);
                    }
                    $this->useTemplate($this->_tplIdx);
                } else {
                    if (null === $this->_otherPageTplIdx) {
                        $this->setSourceFile('/html/typo3-composer/packages/wownaechtebuch/Resources/Public/Pdf/STE_Briefboegen_20211103_Seite2.pdf');
                        $this->_otherPageTplIdx = $this->importPage(1);
                    }
                    $this->useTemplate($this->_otherPageTplIdx);
                }
            }
        };
        $pdf->SetTopMargin(47);
        $pdf->SetAutoPageBreak(true, 25);
        $pdf->AddFont('FiraSans-Light', '', 'FiraSans-Light.php', '/html/typo3-composer/packages/wownaechtebuch/Classes/Fonts/');
        $pdf->AddPage();
        // $tplId = $pdf->importPage(1);
        // $pdf->useTemplate($tplId);
        $pdf->SetFont('FiraSans-Light', '', 10);
        $pdf->SetTextColor(111, 111, 111);

        //Brief Kopf
        $pdf->SetY(54);
        $pdf->SetX(19);
        $pdf->MultiCell(85, 4.55, $user->getGender() == 0 ? 'Herrn' : ($user->getGender() == 1 ? 'Frau' : ''));
        $pdf->SetX(19);
        $pdf->MultiCell(85, 4.55, iconv('UTF-8', 'windows-1252', $user->getFirstName() . ' ' . $user->getLastName()));
        $pdf->SetX(19);
        $pdf->MultiCell(85, 4.55, iconv('UTF-8', 'windows-1252', $user->getAddress()));
        $pdf->SetX(19);
        $pdf->MultiCell(85, 4.55, '');
        $pdf->SetX(19);
        $pdf->MultiCell(85, 4.55, iconv('UTF-8', 'windows-1252', $user->getZip() . ' ' . $user->getCity()));

        // Briefanrede
        // $pdf->SetY(109);
        // $pdf->SetX(20);
        // $pdf->MultiCell(120, 5, $anrede);


        // Fließtext
        // $pdf->SetY(109); // Wenn eine Anrede extra gesetzt wir.
        $pdf->SetY(95);
        $pdf->SetX(19);
        $pdf->MultiCell(175, 6, $decodedText);
        $pdf->Output('F', "/html/typo3-composer/var/transient/Brief-$uid-$date.pdf");

        // Adding the PDF to the default Storage
        $resourceFactory = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance(\TYPO3\CMS\Core\Resource\ResourceFactory::class);
        $storage = $resourceFactory->getDefaultStorage();
        $newFile = $storage->addFile(
            "/html/typo3-composer/var/transient/Brief-$uid-$date.pdf",
            $storage->getRootLevelFolder(),
            "Brief-L$LetterUid-$number-ID$uid-D$date.pdf"
        );

        $fileObject = $storage->getFileByIdentifier($newFile->getIdentifier());

        $queryBuilder = $this->connectionPool->getQueryBuilderForTable('sys_file_reference');
        $affectedRows = $queryBuilder
            ->insert('sys_file_reference')
            ->values([
                'uid_local' => $fileObject->getUid(),
                'tablenames' => 'tx_wownaechtebuch_domain_model_letterrecord',
                'uid_foreign' => $letterRecord->getUid(),
                'fieldname' => 'pdf',
                'pid' => $letterRecord->getPid(),
            ])
            ->executeStatement();

        $uid = $queryBuilder->getConnection()->lastInsertId();

        $queryBuilder = $this->connectionPool->getQueryBuilderForTable('sys_file_reference');
        $queryBuilder
            ->update('tx_wownaechtebuch_domain_model_letterrecord', 'l')
            ->where(
                $queryBuilder->expr()->eq('l.uid', $letterRecord->getUid())
            )
            ->set('pdf', $uid)
            ->executeStatement();

        // $newId =  StringUtility::getUniqueId('NEW');
        // $data = [];
        // $data['sys_file_reference'][$newId] = [
        //     'uid_local' => $fileObject->getUid(),
        //     'tablenames' => 'tx_wownaechtebuch_domain_model_letterrecord',
        //     'uid_foreign' => $letterRecord->getUid(),
        //     'fieldname' => 'pdf',
        //     'pid' => $letterRecord->getPid(),
        // ];
        // $data['tx_wownaechtebuch_domain_model_letterrecord'][$letterRecord->getUid()] = [
        //     'pdf' => $newId, 
        // ];
        
        // $dataHandler = GeneralUtility::makeInstance(DataHandler::class);

        // // Process the DataHandler data
        // $dataHandler->start($data, []);
        // $dataHandler->process_datamap();

        // Error or success reporting
        // if ($dataHandler->errorLog === []) {
        //     // ... handle success
        // } else {
        //     // ... handle errors
        // }


        // Sending the Mail because I cant get the pdf in 

        if (!$letterRecord->getLetter()->isSent() && $letterRecord->getLetter()->getState() == Letter::STATUS_VERSENDET) {
            $child = $letterRecord->getLetter()->getTreatmentRun()->getChild();
            
            $fullName = $child->getFirstName() . " " . $child->getLastName();
            
            $emailtext = '<p>Sehr geehrte Eltern von ' . $fullName . ',</p>

                        <p>vielen Dank für die Einsendung der Protokolldaten.</p>
                        <p>Im Anhang finden Sie Behandlungsvorschläge, mit denen Sie Ihr Kind bei der Behandlung unterstützen können.</p>

                        <p>Viele Grüße aus Münster</p>

                        <p>Ihr Team der Behandlungsbetreuung</p>
                        
                        <img src="https://stero.klingelhose.de/fileadmin/Mail/klingelhose-logo.png" width="300" />
                        <p><b>STERO Enurex GmbH & Co. KG</b><br>
                            Geringhoffstraße 51a<br>
                            48163 Münster | Germany<br>
                            Telefon +49 [0]251 717105<br>
                            Telefax +49 [0]251 712792<br>
                            info@klingelhose.de<br>
                            www.klingelhose.de</p>
                        <img src="https://stero.klingelhose.de/fileadmin/Mail/stero-enurex-logo.png" width="300" />
                        <p>FOLLOW US: <img src="https://stero.klingelhose.de/fileadmin/Mail/instagram.png" width="30" /><img src="https://stero.klingelhose.de/fileadmin/Mail/facebook.png" width="30" /></p>
                        <p><small>Sitz der Gesellschaft Münster                      Persönlich haftende Gesellschafterin:<br>
                                Amtsgericht Münster HRA 5399                      STERO Beteiligungsgesellschaft.mbH<br>
 <br>
                                Geschäftsführung                                      Sitz der Gesellschaft Münster<br>
                                Barbara Stegat | Ursula Leifheit-Stegat          Amtsgericht Münster HRB 65 69<br>
                                </small></p>
                        ';


            $outgoingEmail = GeneralUtility::makeInstance(FluidEmail::class);
            $outgoingEmail
                ->to(new Address($letterRecord->getToAddress(), $fullName))
                ->subject($letterRecord->getSubject())
                ->setTemplate('Klingelhose')
                // ->assign('email', $letterRecord)
                ->assign('email', ['emailtext' => $emailtext])
                ->attachFromPath('/html/typo3-composer/public'.$newFile->getPublicUrl());
            GeneralUtility::makeInstance(MailerInterface::class)->send($outgoingEmail);
            // --
            $letterRecord->getLetter()->setSent(true);
        }
    }
}
