<?php

declare(strict_types=1);

namespace WOWGmbH\Wownaechtebuch\EventListener;

use Symfony\Component\Mime\Address;
use TYPO3\CMS\Core\Mail\FluidEmail;
use TYPO3\CMS\Core\Mail\MailerInterface;
use WOWGmbH\Wownaechtebuch\Event\AfterSendProtocolsEvent;
use WOWGmbH\Wownaechtebuch\Domain\Model\Letter;
use \TYPO3\CMS\Core\Utility\GeneralUtility;
use \TYPO3\CMS\Extbase\Domain\Model\FileReference;

final readonly class SendEmailAfterProtocolsSend
{
    public function __invoke(AfterSendProtocolsEvent $event): void
    {

        $outgoingEmail = GeneralUtility::makeInstance(FluidEmail::class);
        $outgoingEmail
            ->to("behandlungsbetreuung@klingelhose.de")
            ->subject("Neue Registrierung")
            ->setTemplate('SendProtocols')
            ->assign('child', $event->getChild())
            ->assign('week', $event->getWeek());
        GeneralUtility::makeInstance(MailerInterface::class)->send($outgoingEmail);
    }
}
