<?php
return [
    'ctrl' => [
        'title' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_parentuser',
        'label' => 'first_name',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'cruser_id' => 'cruser_id',
        'versioningWS' => true,
        'languageField' => 'sys_language_uid',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => 'first_name,last_name,email,city,zip,region,country,address',
        'iconfile' => 'EXT:wownaechtebuch/Resources/Public/Icons/tx_wownaechtebuch_domain_model_parentuser.gif',
        'security' => [
            'ignorePageTypeRestriction' => true,
        ],
    ],
    'types' => [
        '1' => ['showitem' => 'first_name, last_name, email, city, zip, region, country, address, date_of_archive, state, user, childs, --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:language, sys_language_uid, l10n_parent, l10n_diffsource, --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:access, hidden, starttime, endtime'],
    ],
    'columns' => [
        'sys_language_uid' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.language',
            'config' => [
                'type' => 'language',
            ],
        ],
        'l10n_parent' => [
            'displayCond' => 'FIELD:sys_language_uid:>:0',
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.l18n_parent',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'default' => 0,
                'items' => [
                    ['', 0],
                ],
                'foreign_table' => 'tx_wownaechtebuch_domain_model_parentuser',
                'foreign_table_where' => 'AND {#tx_wownaechtebuch_domain_model_parentuser}.{#pid}=###CURRENT_PID### AND {#tx_wownaechtebuch_domain_model_parentuser}.{#sys_language_uid} IN (-1,0)',
            ],
        ],
        'l10n_diffsource' => [
            'config' => [
                'type' => 'passthrough',
            ],
        ],
        'hidden' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.visible',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        0 => '',
                        1 => '',
                        'invertStateDisplay' => true
                    ]
                ],
            ],
        ],
        'starttime' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'eval' => 'datetime,int',
                'default' => 0,
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
        ],
        'endtime' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'eval' => 'datetime,int',
                'default' => 0,
                'range' => [
                    'upper' => mktime(0, 0, 0, 1, 1, 2038)
                ],
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
        ],

        'gender' => [
            'exclude' => 0,
            'label' => 'LLL:EXT:femanager/Resources/Private/Language/locallang_db.xlf:' .
                'tx_femanager_domain_model_user.gender',
            'config' => [
                'type' => 'radio',
                'items' => [
                    [
                        'LLL:EXT:femanager/Resources/Private/Language/locallang_db.xlf:' .
                        'tx_femanager_domain_model_user.gender.item0',
                        '0',
                    ],
                    [
                        'LLL:EXT:femanager/Resources/Private/Language/locallang_db.xlf:' .
                        'tx_femanager_domain_model_user.gender.item1',
                        '1',
                    ],
                    [
                        'LLL:EXT:femanager/Resources/Private/Language/locallang_db.xlf:' .
                        'tx_femanager_domain_model_user.gender.item2',
                        '2',
                    ],
                ],
            ],
        ],
        'first_name' => [
            'exclude' => false,
            'label' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_parentuser.first_name',
            'description' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_parentuser.first_name.description',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim,null',
                'required' => true,
                'default' => null
            ],
        ],
        'last_name' => [
            'exclude' => false,
            'label' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_parentuser.last_name',
            'description' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_parentuser.last_name.description',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim,null',
                'required' => true,
                'default' => null
            ],
        ],
        'email' => [
            'exclude' => false,
            'label' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_parentuser.email',
            'description' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_parentuser.email.description',
            'config' => [
                'type' => 'email',
                'required' => true,
                'nullable' => true,
                'default' => null
            ]
        ],
        'city' => [
            'exclude' => false,
            'label' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_parentuser.city',
            'description' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_parentuser.city.description',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim,null',
                'required' => true,
                'default' => null
            ],
        ],
        'zip' => [
            'exclude' => false,
            'label' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_parentuser.zip',
            'description' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_parentuser.zip.description',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim,null',
                'required' => true,
                'default' => null
            ],
        ],
        'region' => [
            'exclude' => false,
            'label' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_parentuser.region',
            'description' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_parentuser.region.description',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim,null',
                'default' => null
            ],
        ],
        'country' => [
            'exclude' => false,
            'label' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_parentuser.country',
            'description' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_parentuser.country.description',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim,null',
                'default' => null
            ],
        ],
        'address' => [
            'exclude' => false,
            'label' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_parentuser.address',
            'description' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_parentuser.address.description',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim,null',
                'required' => true,
                'default' => null
            ],
        ],
        'date_of_archive' => [
            'exclude' => false,
            'label' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_parentuser.date_of_archive',
            'description' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_parentuser.date_of_archive.description',
            'config' => [
                'type' => 'datetime',
                'format' => 'datetime',
                'size' => 20,
                'nullable' => true,
                'default' => null
            ],
        ],
        'state' => [
            'exclude' => false,
            'label' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_parentuser.state',
            'description' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_parentuser.state.description',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'required' => true,
                'default' => 0
            ]
        ],
        'childs' => [
            'label' => 'Childs',
            'config' => [
                'type' => 'inline',
                'foreign_table' => 'tx_wownaechtebuch_domain_model_child',
                'foreign_field' => 'parent_user',
            ],
        ],
        'user' => [
            'exclude' => false,
            'label' => 'LLL:EXT:frontend/Resources/Private/Language/locallang_tca.xlf:fe_users',
            'description' => 'LLL:EXT:frontend/Resources/Private/Language/locallang_tca.xlf:fe_users',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'fe_users',
                'default' => 0,
                'minitems' => 0,
                'maxitems' => 1,
            ],
        ],
    ],
];
