<?php
return [
    'ctrl' => [
        'title' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_productrecord',
        'label' => 'serial_number',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'cruser_id' => 'cruser_id',
        'versioningWS' => true,
        'languageField' => 'sys_language_uid',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => 'serial_number,protuct_name',
        'iconfile' => 'EXT:wownaechtebuch/Resources/Public/Icons/tx_wownaechtebuch_domain_model_productrecord.gif',
        'security' => [
            'ignorePageTypeRestriction' => true,
        ],
    ],
    'types' => [
        '1' => ['showitem' => 'serial_number, protuct_name, child, product, --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:language, sys_language_uid, l10n_parent, l10n_diffsource, --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:access, hidden, starttime, endtime'],
    ],
    'columns' => [
        'sys_language_uid' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.language',
            'config' => [
                'type' => 'language',
            ],
        ],
        'l10n_parent' => [
            'displayCond' => 'FIELD:sys_language_uid:>:0',
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.l18n_parent',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'default' => 0,
                'items' => [
                    ['', 0],
                ],
                'foreign_table' => 'tx_wownaechtebuch_domain_model_productrecord',
                'foreign_table_where' => 'AND {#tx_wownaechtebuch_domain_model_productrecord}.{#pid}=###CURRENT_PID### AND {#tx_wownaechtebuch_domain_model_productrecord}.{#sys_language_uid} IN (-1,0)',
            ],
        ],
        'l10n_diffsource' => [
            'config' => [
                'type' => 'passthrough',
            ],
        ],
        'hidden' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.visible',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        0 => '',
                        1 => '',
                        'invertStateDisplay' => true
                    ]
                ],
            ],
        ],
        'starttime' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'eval' => 'datetime,int',
                'default' => 0,
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
        ],
        'endtime' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'eval' => 'datetime,int',
                'default' => 0,
                'range' => [
                    'upper' => mktime(0, 0, 0, 1, 1, 2038)
                ],
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
        ],

        'serial_number' => [
            'exclude' => false,
            'label' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_productrecord.serial_number',
            'description' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_productrecord.serial_number.description',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim',
                'required' => true,
                'default' => ''
            ],
        ],
        'protuct_name' => [
            'exclude' => false,
            'label' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_productrecord.protuct_name',
            'description' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_productrecord.protuct_name.description',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim',
                'required' => true,
                'default' => ''
            ],
        ],
        'child' => [
            'exclude' => false,
            'label' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_productrecord.child',
            'description' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_productrecord.child.description',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'tx_wownaechtebuch_domain_model_child',
                'default' => 0,
                'minitems' => 0,
                'maxitems' => 1,
            ],

        ],
        'product' => [
            'exclude' => false,
            'label' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_productrecord.product',
            'description' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_productrecord.product.description',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'tx_wownaechtebuch_domain_model_product',
                'default' => 0,
                'minitems' => 0,
                'maxitems' => 1,
            ],

        ],
    
    ],
];
