
const config = [
  {
    questiontext: "Trocken durchgeschlafen",
    deactivate: "all"
  },
  {
    questiontext: "vom Harndrang geweckt",
    deactivate: "all"
  },
  // {
  //   questiontext: "nicht wach geworden",
  //   deactivate: ["Trocken durchgeschlafen", "vom Harndrang geweckt", "wach geworden"],
  //   mustBeFilled: {
  //     logic: "or",
  //     conditions: ["Unterhose", "Schlafanzug", "Bett"]
  //   }
  // },
  {
    questiontext: "wach geworden",
    deactivate: ["Trocken durchgeschlafen", "vom Harndrang geweckt", "nicht wach geworden"],
    mustBeFilled: {
      logic: "or",
      conditions: ["Unterhose", "Schlafanzug", "Bett"]
    }
  },


  {
    questiontext: "Unterhose",
    deactivate: [],
    activeWhen: {
      logic: "or",
      conditions: ["wach geworden", "nicht wach geworden"]
    }
  },
  {
    questiontext: "Schlafanzug",
    deactivate: ["Unterhose"],
    activeWhen: {
      logic: "or",
      conditions: ["wach geworden", "nicht wach geworden"]
    },
    checkWhenCheck: ["Unterhose"]
  },
  {
    questiontext: "Bett",
    deactivate: ["Schlafanzug", "Unterhose"],
    activeWhen: {
      logic: "or",
      conditions: ["wach geworden", "nicht wach geworden"]
    },
    checkWhenCheck: ["Schlafanzug", "Unterhose"]
  }

];

$(document).ready(function () {
  // Iteriere über die Konfigurationsobjekte
  $('input[type="checkbox"]').change(function () {
    var surveyRecord = $(this).attr('data-surveyrecord');
    config.forEach(function (rule) {
      if (rule.activeWhen) {
        let active = rule.activeWhen.logic == "and";
        rule.activeWhen.conditions.forEach(function (questiontext) {
          if (rule.activeWhen.logic == "and") active &= $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + questiontext + '"]').is(':checked');
          else active |= $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + questiontext + '"]').is(':checked');
        });

        $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + rule.questiontext + '"]').toggleClass('notAcitvated', !active);
        let disabled = $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + rule.questiontext + '"]').hasClass('deactivated');
        $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + rule.questiontext + '"]').prop('disabled', !active || disabled);
        if (!active) $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + rule.questiontext + '"]').prop('checked', false);
      }

      if (rule.mustBeFilled) {
        let mustBeFilled = rule.mustBeFilled.logic == "and";
        if ($('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + rule.questiontext + '"]').is(':checked')) {
          rule.mustBeFilled.conditions.forEach(function (questiontext) {
            if (rule.mustBeFilled.logic == "and") mustBeFilled &= $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + questiontext + '"]').is(':checked');
            else mustBeFilled |= $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + questiontext + '"]').is(':checked');
          });
        }
        else mustBeFilled = true;

        rule.mustBeFilled.conditions.forEach(function (questiontext) {
          $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + questiontext + '"]').toggleClass('missing', !mustBeFilled);
        })
      }

    });
  })

  config.forEach(function (rule) {

    $('input[type="checkbox"][data-questiontext="' + rule.questiontext + '"]').change(function () {
      var surveyRecord = $(this).attr('data-surveyrecord');

      if ($(this).is(':checked')) {
        if (rule.deactivate === "all") {
          // Deaktiviere alle Checkboxen in der gleichen surveyrecord-Reihe außer der aktuellen
          $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"]').not(this).prop('disabled', true);
          $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"]').not(this).prop('checked', false);
        } else {
          // Deaktiviere spezifische Checkboxen in der gleichen surveyrecord-Reihe
          rule.deactivate.forEach(function (checkboxId) {
            $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + checkboxId + '"]').addClass('deactivated');
            $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + checkboxId + '"]').prop('disabled', true);
            $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + checkboxId + '"]').prop('checked', false);
          });
        }

        if (rule.checkWhenCheck && rule.checkWhenCheck.length >= 1) {
          rule.checkWhenCheck.forEach(function (questiontext) {
            $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + questiontext + '"]').prop('checked', true);
          });
        }
      } else {
        // Aktiviere alle Checkboxen in der gleichen surveyrecord-Reihe
        if (rule.deactivate === "all") {
          $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"]').each(function (checkbox) {
            $(this).removeClass('deactivated');


            let notAcitvated = $(this).hasClass('notAcitvated');
            if (!notAcitvated) $(this).prop('disabled', false);
          });
        }
        else {
          rule.deactivate.forEach(function (checkboxId) {
            $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + checkboxId + '"]').removeClass('deactivated');


            let notAcitvated = $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + checkboxId + '"]').hasClass('notAcitvated', false);
            $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + checkboxId + '"]').prop('disabled', notAcitvated);
          });
        }

        if (rule.checkWhenCheck && rule.checkWhenCheck.length >= 1) {
          rule.checkWhenCheck.forEach(function (questiontext) {
            $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + questiontext + '"]').prop('checked', false);
          });
        }
      }

    });


  });

  checkForActiveWhen();
});

function checkForActiveWhen() {
  config.forEach(function (rule) {
    if (rule.activeWhen) {
      let active = rule.activeWhen.logic == "and";
      rule.activeWhen.conditions.forEach(function (questiontext) {
        if (rule.activeWhen.logic == "and") active &= $('input[type="checkbox"][data-questiontext="' + questiontext + '"]').is(':checked');
        else active |= $('input[type="checkbox"][data-questiontext="' + questiontext + '"]').is(':checked');
      })

      $('input[type="checkbox"][data-questiontext="' + rule.questiontext + '"]').toggleClass('notAcitvated', !active);
      let disabled = $('input[type="checkbox"][data-questiontext="' + rule.questiontext + '"]').hasClass('notAcitvated', !active);
      $('input[type="checkbox"][data-questiontext="' + rule.questiontext + '"]').prop('disabled', !active || disabled);
      if (!active || disabled) $('input[type="checkbox"][data-questiontext="' + rule.questiontext + '"]').prop('checked', false);
    }
  });
}


//
// Auto Date
//


$(document).ready(function () {

  if ($('#treatmentRun-start').data('treatmentrunstart')) {
    $('[type="date"]').each(function () {
      let day = $(this).closest('.protocol-record').data('day') - 1;
      let week = $(this).closest('.protocol-record').data('week') - 1;
      let date = new Date($('#treatmentRun-start').data('treatmentrunstart'));

      $(this).val(date.addDays(7 * week + day).toISOString().split('T')[0]);
      $(this).prop('readonly', true);

    });
  }
});

Date.prototype.addDays = function (days) {
  var date = new Date(this.valueOf());
  date.setDate(date.getDate() + days);
  return date;
}

// // Validierung vor dem Senden des Formulars
// $('[name="protocolData"]').on('submit', function(event) {
//   let allRowsValid = true;

//   // Überprüfe jede Zeile mit der Klasse .protocol-record
//   $('.protocol-record').each(function() {
//     let hasCheckedCheckbox = $(this).find('input[type="checkbox"]:checked').length > 0;

//     if (!hasCheckedCheckbox) {
//       allRowsValid = false;
//       // Zeige eine Fehlermeldung oder markiere die ungültige Zeile
//       $(this).css('background-color', '#f8d7da'); // Fehlerhervorhebung
//     } else {
//       $(this).css('background-color', ''); // Entferne Fehlerhervorhebung
//     }
//   });

//   // Wenn eine Zeile keine angekreuzte Checkbox hat, verhindere das Absenden
//   if (!allRowsValid) {
//     event.preventDefault();
//     alert('Bitte füllen Sie alle Protokolle vollständig aus, indem Sie mindestens eine Box pro Zeile ankreuzen.');
//   }
// });


// // Senden von Protokollen
// $('.sent').on('click', function(event) {
//   let allRowsValid = true;

//   // Überprüfe jede Zeile mit der Klasse .protocol-record
//   $('.protocol-record').each(function() {
//     let hasCheckedCheckbox = $(this).find('input[type="checkbox"]:checked').length > 0;

//     if (!hasCheckedCheckbox) {
//       allRowsValid = false;
//       // Zeige eine Fehlermeldung oder markiere die ungültige Zeile
//       $(this).css('background-color', '#f8d7da'); // Fehlerhervorhebung
//     } else {
//       $(this).css('background-color', ''); // Entferne Fehlerhervorhebung
//     }
//   });

//   // Wenn eine Zeile keine angekreuzte Checkbox hat, verhindere das Absenden
//   if (!allRowsValid) {
//     event.preventDefault();
//     alert('Bitte füllen Sie alle Protokolle vollständig aus, indem Sie mindestens eine Box pro Zeile ankreuzen.');
//   }
// });


// $('.plus').click(function(){
//   let newRow = $(this).closest('tr').clone();
//   newRow.find('input').val(''); // Setzt alle Input-Felder zurück
//   newRow.insertAfter($(this).closest('tr'));
// });
// $('.minus').click(function() {
//   $(this).closest('tr').remove();
// });

$('input[data-questiontext="wach geworden"]').change(function () {
  console.log('chgecker');
});
$('input[data-questiontext="nicht wach geworden"]').change(function () {
  console.log('chgecker2');
  $(this).parents('tr').addClass('test')
  $(this).parents('tr').find('input[data-questiontext="Unterhose"]').toggleClass('someclass');
  $(this).parents('tr').find('input[data-questiontext="Schlafanzug"]').toggleClass('someclass');
  $(this).parents('tr').find('input[data-questiontext="Bett"]').toggleClass('someclass');
  console.log($(this).parents('tr').find('[data-questiontext="Unterhose"]'));

});

document.querySelectorAll('.btn.plus-ajax').forEach(button => { // Zeile 270 (Beginn des forEach)
  button.addEventListener('click', function (e) {
    e.preventDefault();

    const child = this.dataset.child;
    const day = this.dataset.day;
    const week = this.dataset.week;
    const clickedButton = this; // Referenz auf den geklickten Button

    const url = `https://stero.klingelhose.de`
              + `/kundenpflege?type=123456`
              + `&tx_wownaechtebuch_clientmanagament[action]=createProtocolForCM`
              + `&tx_wownaechtebuch_clientmanagament[child]=${child}`
              + `&tx_wownaechtebuch_clientmanagament[controller]=SurveyRecord`
              + `&tx_wownaechtebuch_clientmanagament[day]=${day}`
              + `&tx_wownaechtebuch_clientmanagament[week]=${week}`;

    console.log("Requesting URL:", url);

    fetch(url) // Gibt ein Promise (P1) zurück
      .then(response => { // Callback für P1. Wird ausgeführt, wenn P1 settled.
        console.log("Raw response object:", response);
        if (!response.ok) {
            throw new Error(`Network response was not ok, status: ${response.status}`); // Wirft Fehler, der von .catch() gefangen wird
        }
        return response.text(); // Gibt ein neues Promise (P2) zurück
      }) // Das Ergebnis dieses .then() ist P2
      .then(html => { // Callback für P2. Wird ausgeführt, wenn P2 mit dem HTML-Text resolved.
        console.log("Received HTML content:", html); // html ist der Text von der AJAX-Antwort

        // JETZT das Formular auf der aktuellen Seite absenden
        const form = clickedButton.closest('form'); // Finde das Formular, zu dem der Button gehört
                                                    // ODER: const form = document.getElementById('meineFormId');
        if (form) {
          console.log("Submitting form on current page:", form);
          form.submit(); // Sendet das Formular ab. Diese Operation ist synchron und gibt kein Promise zurück.
        } else {
          console.warn("Button is not inside a form, or specified form not found.");
        }
        // WICHTIG: Diese Callback-Funktion (html => { ... }) gibt implizit `undefined` zurück,
        // da kein `return`-Statement vorhanden ist.
        // Wenn du hier nichts zurückgibst, ist das Ergebnis dieses .then()-Blocks `undefined`.
      }) // Das Ergebnis dieses .then()-Blocks ist `undefined`
      .catch(error => { // ZEILE 314 (VERMUTLICH):
                        // Dieses .catch() wird auf dem Ergebnis des vorherigen .then()-Blocks aufgerufen.
                        // Wenn dieser `undefined` ist, bekommst du den Fehler:
                        // "Cannot read properties of undefined (reading 'catch')"
                        // oder genauer gesagt, wenn `.catch` selbst das Problem ist, dann würde
                        // das `undefined.catch(...)` den Fehler auslösen.
        console.error('Error during fetch or in .then() blocks:', error);
        alert('Fehler: ' + error.message);
      });
  });
});
