$(document).ready(function() {
    // ID des Senden-Buttons. Bitte anpassen, falls nötig.
    const submitButton = $('#send-button'); 

    // Die zentrale Validierungsfunktion
    function validateFormState() {
        let isFormFullyValid = true;

        // Gehe durch jede Zeile, die validiert werden muss
        $('.protocol-record').each(function() {
            const row = $(this);
            let isRowValid = false;

            // Finde alle relevanten Eingabefelder in dieser Zeile (außer Datum)
            const inputs = row.find('input[type="text"], input[type="number"], input[type="checkbox"]');
            
            // --- Logik-Teil 1: Ist die Zeile durch eine Eingabe gültig? ---
            inputs.each(function() {
                const input = $(this);
                // Prüfe, ob eine Checkbox angehakt ist ODER ein Text-/Zahlenfeld ausgefüllt ist.
                if ((input.is(':checkbox') && input.is(':checked')) || 
                    (!input.is(':checkbox') && input.val().trim() !== '')) {
                    isRowValid = true;
                    return false; // Bricht die innere .each-Schleife ab, da die Zeile gültig ist.
                }
            });

            // --- Logik-Teil 2: Wenn nicht, ist die Zeile vielleicht gültig, weil alles deaktiviert ist? ---
            if (!isRowValid) {
                const totalInputs = inputs.length;
                const disabledInputs = inputs.filter(':disabled').length;

                // Wenn es in der Zeile überhaupt Eingabefelder gibt UND alle davon deaktiviert sind,
                // gilt die Zeile ebenfalls als "abgeschlossen" und somit gültig.
                if (totalInputs > 0 && totalInputs === disabledInputs) {
                    isRowValid = true;
                }
            }
            
            // Wenn nach beiden Prüfungen die Zeile immer noch nicht gültig ist,
            // ist das gesamte Formular ungültig.
            if (!isRowValid) {
                isFormFullyValid = false;
                return false; // Bricht die äußere .each-Schleife ab, da das Ergebnis feststeht.
            }
        });

        // Aktiviere oder deaktiviere den Senden-Button basierend auf dem Gesamtergebnis
        submitButton.prop('disabled', !isFormFullyValid);
    }

    // --- Event-Listener, der die Validierung auslöst ---
    // Wir binden den Listener an das Formular und delegieren an die Inputs.
    // Das ist effizient und funktioniert auch für dynamisch hinzugefügte Zeilen.
    // 'input' reagiert auf Textänderungen, 'change' auf Klicks bei Checkboxen.
    $('form').on('input change', '.protocol-record input', function() {
        // Kurze Verzögerung (setTimeout) stellt sicher, dass Ihr anderes Skript
        // seine DOM-Änderungen (z.B. das Deaktivieren) abgeschlossen hat, bevor wir validieren.
        setTimeout(validateFormState, 100); 
    });

    // Führe die Validierung einmal initial beim Laden der Seite aus.
    validateFormState();
});