<?php
defined('TYPO3') || die();

(static function() {
    \TYPO3\CMS\Extbase\Utility\ExtensionUtility::configurePlugin(
        'Wownaechtebuch',
        'Admin',
        [
            \WOWGmbH\Wownaechtebuch\Controller\ParentUserController::class => 'listForAdmin, show, new, create, edit, update, delete, archive, unarchive',
            \WOWGmbH\Wownaechtebuch\Controller\ChildController::class => 'show, listForAdmin, archive, unarchive, edit, delete',
            \WOWGmbH\Wownaechtebuch\Controller\SurveyRecordController::class => 'show, listForAdminByChild, listByChild',
            \WOWGmbH\Wownaechtebuch\Controller\LetterRecordController::class => 'show, new, create, edit, update, update, listForAdminByChild',
            \WOWGmbH\Wownaechtebuch\Controller\LetterController::class => 'show, new, create, edit, update, listForAdminByChild, listForAdmin, archive, unarchive, delete',
        ],
        [
            \WOWGmbH\Wownaechtebuch\Controller\ParentUserController::class => 'listForAdmin, show, new, create, edit, update, delete, archive, unarchive',
            \WOWGmbH\Wownaechtebuch\Controller\ChildController::class => 'show, listForAdmin, archive, unarchive, edit, delete',
            \WOWGmbH\Wownaechtebuch\Controller\SurveyRecordController::class => 'show, listForAdminByChild, listByChild',
            \WOWGmbH\Wownaechtebuch\Controller\LetterRecordController::class => 'show, new, create, edit, update, listForAdminByChild',
            \WOWGmbH\Wownaechtebuch\Controller\LetterController::class => 'show, new, create, edit, update, listForAdminByChild, listForAdmin, archive, unarchive, delete',
        ],
        \TYPO3\CMS\Extbase\Utility\ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
    );

    \TYPO3\CMS\Extbase\Utility\ExtensionUtility::configurePlugin(
        'Wownaechtebuch',
        'ClientManagament',
        [
            \WOWGmbH\Wownaechtebuch\Controller\ParentUserController::class => 'listForCM, show, new, create, editForCM, updateForCM, delete',
            \WOWGmbH\Wownaechtebuch\Controller\ChildController::class => 'listForCM, show, new, create, editForCM, updateForCM, editDocForCM, delete',
            \WOWGmbH\Wownaechtebuch\Controller\TreatmentRunController::class => 'index, list, show, new, create, edit, delete',
            \WOWGmbH\Wownaechtebuch\Controller\SurveyRecordController::class => 'listForCMByChild, show, new, createForCM, editForCM, updateForCM, deleteForCM, fillForCM, editProtocolForCM, editPrevProtocolForCM, editNextProtocolForCM, saveProtocolsForCM, sendProtocolsForCM, editRegistrationSurveyForCM, fillRegistrationSurveyForCM, updateRegistrationSurveyForCM, createProtocolForCM, deleteProtocolForCM, addProtocol, saveProtocolsForCMTest, createAndSaveProtocolForCM, createProtocol',
            \WOWGmbH\Wownaechtebuch\Controller\ProductRecordController::class => 'newForCM, createForCM',
            \WOWGmbH\Wownaechtebuch\Controller\TreatmentRunController::class => 'updateForCM',
        ],
        [
            \WOWGmbH\Wownaechtebuch\Controller\ParentUserController::class => 'listForCM, show, new, create, editForCM, updateForCM, delete',
            \WOWGmbH\Wownaechtebuch\Controller\ChildController::class => 'listForCM, show, new, create, editForCM, updateForCM, editDocForCM, delete',
            \WOWGmbH\Wownaechtebuch\Controller\TreatmentRunController::class => 'index, list, show, new, create, edit, delete',
            \WOWGmbH\Wownaechtebuch\Controller\SurveyRecordController::class => 'listForCMByChild, show, new, createForCM, editForCM, updateForCM, deleteForCM, fillForCM, editProtocolForCM, editPrevProtocolForCM, editNextProtocolForCM, saveProtocolsForCM, sendProtocolsForCM, editRegistrationSurveyForCM, fillRegistrationSurveyForCM, updateRegistrationSurveyForCM, createProtocolForCM, deleteProtocolForCM, addProtocol, saveProtocolsForCMTest, createAndSaveProtocolForCM, createProtocol',
            \WOWGmbH\Wownaechtebuch\Controller\ProductRecordController::class => 'newForCM, createForCM',
            \WOWGmbH\Wownaechtebuch\Controller\TreatmentRunController::class => 'updateForCM',
        ],
        \TYPO3\CMS\Extbase\Utility\ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
    );

    \TYPO3\CMS\Extbase\Utility\ExtensionUtility::configurePlugin(
        'Wownaechtebuch',
        'UserProfile',
        [
            \WOWGmbH\Wownaechtebuch\Controller\ParentUserController::class => 'showLoggedUser, show, editForParentUser, update, updateForParentUser',
            \WOWGmbH\Wownaechtebuch\Controller\ProductRecordController::class => 'new, create',
            \WOWGmbH\Wownaechtebuch\Controller\ChildController::class => 'new, show, create, listForTreatmentRun',
            \WOWGmbH\Wownaechtebuch\Controller\SurveyRecordController::class => 'show, fill, edit, update',
            \WOWGmbH\Wownaechtebuch\Controller\LetterController::class => 'listForParentUser, show',
            \WOWGmbH\Wownaechtebuch\Controller\TreatmentRunController::class => 'relapse',

        ],
        [
            \WOWGmbH\Wownaechtebuch\Controller\ParentUserController::class => 'showLoggedUser, show, editForParentUser, update, updateForParentUser',
            \WOWGmbH\Wownaechtebuch\Controller\ProductRecordController::class => 'new',
            \WOWGmbH\Wownaechtebuch\Controller\ChildController::class => 'new, show, create, listForTreatmentRun',
            \WOWGmbH\Wownaechtebuch\Controller\SurveyRecordController::class => 'show, fill, edit, update',
            \WOWGmbH\Wownaechtebuch\Controller\LetterController::class => 'listForParentUser, show',
            \WOWGmbH\Wownaechtebuch\Controller\TreatmentRunController::class => 'relapse',
        ],
        \TYPO3\CMS\Extbase\Utility\ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
    );
    
    \TYPO3\CMS\Extbase\Utility\ExtensionUtility::configurePlugin(
        'Wownaechtebuch',
        'Naechtebuch',
        [
            \WOWGmbH\Wownaechtebuch\Controller\ChildController::class => 'listForNaechtebuch, noUser',
            \WOWGmbH\Wownaechtebuch\Controller\SurveyRecordController::class => 'editProtocol, createProtocol, deleteProtocol, editPrevProtocol, editNextProtocol, saveProtocols, saveProtocolsKeepWeek, sendProtocols',
            \WOWGmbH\Wownaechtebuch\Controller\TreatmentRunController::class => 'update',
        ],
        [
            \WOWGmbH\Wownaechtebuch\Controller\ChildController::class => 'listForNaechtebuch, noUser',
            \WOWGmbH\Wownaechtebuch\Controller\SurveyRecordController::class => 'editProtocol, createProtocol, deleteProtocol, editPrevProtocol, editNextProtocol, saveProtocols, saveProtocolsKeepWeek, sendProtocols',
            \WOWGmbH\Wownaechtebuch\Controller\TreatmentRunController::class => 'update',
        ],
        \TYPO3\CMS\Extbase\Utility\ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
    );
    
    \TYPO3\CMS\Extbase\Utility\ExtensionUtility::configurePlugin(
        'Wownaechtebuch',
        'Survey',
        [
            \WOWGmbH\Wownaechtebuch\Controller\ChildController::class => 'listForSurvey, noUser',
            \WOWGmbH\Wownaechtebuch\Controller\SurveyController::class => 'listRequired',
            \WOWGmbH\Wownaechtebuch\Controller\SurveyRecordController::class => 'fill, edit, update, show',
        ],
        [
            \WOWGmbH\Wownaechtebuch\Controller\ChildController::class => 'listForSurvey, noUser',
            \WOWGmbH\Wownaechtebuch\Controller\SurveyController::class => 'listRequired',
            \WOWGmbH\Wownaechtebuch\Controller\SurveyRecordController::class => 'fill, edit, update, show',
        ],
        \TYPO3\CMS\Extbase\Utility\ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
    );

    \TYPO3\CMS\Extbase\Utility\ExtensionUtility::configurePlugin(
        'Wownaechtebuch',
        'Registration',
        [
            \WOWGmbH\Wownaechtebuch\Controller\ProductRecordController::class => 'newForUser, createForUser',
            \WOWGmbH\Wownaechtebuch\Controller\ChildController::class => 'newForUser, createForUser',
            \WOWGmbH\Wownaechtebuch\Controller\ParentUserController::class => 'editForUser, updateForUser, show',
            \WOWGmbH\Wownaechtebuch\Controller\SurveyRecordController::class => 'fillRegistrationSurvey, editRegistrationSurvey, updateRegistrationSurvey',
            
        ],
        [
            \WOWGmbH\Wownaechtebuch\Controller\ProductRecordController::class => 'newForUser, createForUser',
            \WOWGmbH\Wownaechtebuch\Controller\ChildController::class => 'newForUser, createForUser',
            \WOWGmbH\Wownaechtebuch\Controller\ParentUserController::class => 'editForUser, updateForUser, show',
            \WOWGmbH\Wownaechtebuch\Controller\SurveyRecordController::class => 'fillRegistrationSurvey, editRegistrationSurvey, updateRegistrationSurvey',
        ],
        \TYPO3\CMS\Extbase\Utility\ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
    );



    // wizards
    \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addPageTSConfig(
        'mod {
            wizards.newContentElement.wizardItems.ext-wownaechtebuch {
                header = WOW Naechtebuch
                after = common
                elements {
                    admin {
                        iconIdentifier = wownaechtebuch-plugin-admin
                        title = LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_admin.name
                        description = LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_admin.description
                        tt_content_defValues {
                            CType = wownaechtebuch_admin
                        }
                    }
                    clientmanagament {
                        iconIdentifier = wownaechtebuch-plugin-clientmanagament
                        title = LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_clientmanagament.name
                        description = LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_clientmanagament.description
                        tt_content_defValues {
                            CType = wownaechtebuch_clientmanagament
                        }
                    }
                    userprofile {
                        iconIdentifier = wownaechtebuch-plugin-userprofile
                        title = LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_userprofile.name
                        description = LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_userprofile.description
                        tt_content_defValues {
                            CType = wownaechtebuch_userprofile
                        }
                    }
                    naechtebuch {
                        iconIdentifier = wownaechtebuch-plugin-naechtebuch
                        title = LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_naechtebuch.name
                        description = LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_naechtebuch.description
                        tt_content_defValues {
                            CType = wownaechtebuch_naechtebuch
                        }
                    }
                    survey {
                        iconIdentifier = wownaechtebuch-plugin-survey
                        title = LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_survey.name
                        description = LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_survey.description
                        tt_content_defValues {
                            CType = wownaechtebuch_survey
                        }
                    }
                    registration {
                        iconIdentifier = wownaechtebuch-plugin-registration
                        title = LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_registration.name
                        description = LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_registration.description
                        tt_content_defValues {
                            CType = wownaechtebuch_registration
                        }
                    }
                }
                show = *
            }
       }'
    );
})();

$GLOBALS['TYPO3_CONF_VARS']['MAIL']['templateRootPaths'][110] = 'EXT:wownaechtebuch/Resources/Private/Templates/Email/';
$GLOBALS['TYPO3_CONF_VARS']['MAIL']['layoutRootPaths'][110] = 'EXT:wownaechtebuch/Resources/Private/Layouts/';
/***************
 * PageTS
 */
\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addPageTSConfig('<INCLUDE_TYPOSCRIPT: source="FILE:EXT:wownaechtebuch/Configuration/TsConfig/Page/All.tsconfig">');
